﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

using sharpPDF;
using System.Drawing;

namespace PI.ZB.N1200.ELearning.BL
{
    public static partial class PDFReport
    {
        /// <summary>
        /// Klasa tworzaca dokumenty PDF
        /// </summary>
        internal class PDFCreator
        {
            // dokument PDF
            private pdfDocument _document = null;
            private pdfPage _page;

            public PDFCreator(string ReportFontDir)
            {
            }

            public void CreateCert(
                string PDFProjectName, string PDFTitle, string PDFAuthor,
                string DestinationFileName,
                string CertFileBackgroundName,
                string StudentName,
                string StudentEvaluationName,
                string StudentEndTestEvaluationName,
                DateTime ExamDate
                )
            {

                Image _objBmpImage = Image.FromFile(CertFileBackgroundName);
                Graphics _objGraphics = Graphics.FromImage(_objBmpImage);

                StringFormat strFormat = new StringFormat();
                strFormat.Alignment = StringAlignment.Center;
                strFormat.LineAlignment = StringAlignment.Center;

                Font _normal = new Font("Tahoma", 16);
                Font _bold = new Font("Tahoma", 16, FontStyle.Bold);
                Font _largeBold = new Font("Tahoma", 18, FontStyle.Bold);
                Brush _colorBrush = new SolidBrush(Color.FromArgb(99, 0, 0));

                this.AddParagraph(_objGraphics, "wydany przez podmiot certyfikujący:", _normal, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, "Zachodniopomorską Szkołę Biznesu w Szczecinie", _normal, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, String.Format("w dniu {0:dd.MM.yyyy} roku", ExamDate), _bold, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, "Stwierdza się, że osoba " + StudentName + " ukończyła", _normal, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, "kurs przedsiębiorczości", _normal, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, "w systemie e-learningowym eduKariera uzyskując stanowisko", _normal, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, StudentEvaluationName, _largeBold, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, "", _normal, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, "", _normal, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, "Jako weryfikację zdobytych kompetencji osoba " + StudentName, _normal, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, "zdała egzamin podsumowujący na ocenę " + StudentEndTestEvaluationName + ",", _normal, _colorBrush, strFormat);
                this.AddParagraph(_objGraphics, "co potwierdza posiadanie kompetencji z zakresu przedsiębiorczości.", _normal, _colorBrush, strFormat);

                string _imageFilePathName = DestinationFileName.Replace(".pdf", ".jpg");

                _objBmpImage.Save(_imageFilePathName, System.Drawing.Imaging.ImageFormat.Jpeg);
                _objGraphics.Dispose();
                _objGraphics = null;
                _objBmpImage.Dispose();
                _objBmpImage = null;

                // Initialize the PDF document
                _document = new pdfDocument(PDFProjectName, PDFAuthor);
                // Create new page
                _page = _document.addPage(sharpPDF.Enumerators.predefinedPageSize.csA4Page);
                _document.addImageReference(_imageFilePathName, "B");
                _page.addImage(_document.getImageReference("B"), 3, 2);
                // save PDF
                _document.createPDF(DestinationFileName);
                // Clean up
                _page = null;
                _document = null;
            }            
           
            int _paragraphsCount = 0;
            int _lineHeight = 30;
            int _top = 200;
            /// <summary>
            /// Add a paragraph object containing the specified element to the PDF document.
            /// </summary>
            /// <param name="doc">Document to which to add the paragraph.</param>
            /// <param name="alignment">Alignment of the paragraph.</param>
            /// <param name="font">Font to assign to the paragraph.</param>
            /// <param name="content">Object that is the content of the paragraph.</param>
            private void AddParagraph(Graphics g, string Content, Font f, Brush b, StringFormat format)
            {
                g.DrawString(Content, f, b, new RectangleF(0, _top + (_paragraphsCount * _lineHeight), 589, _lineHeight), format);
                _paragraphsCount++;
            }            
        }
    }
}